#ifndef LLF_ERROR_H
#define LLF_ERROR_H

/*
* All the includes that are needed for code using this module to
* Compile correctly should be #included here.
*/

#include "CE2_error.h"

#ifdef __cplusplus
extern "C"
{
#endif

/*
* Creation date : Thu Oct 11 15:12:31 2007
* Last modified : %modify_time%
*/
/** @file
* \brief This file contains declaration of low level function that
* provides a error description retreiving.
* 
* \version LLF_HASH.h#1:csrc:1
* \author Alexander Masiuk
* \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
* All Rights reserved
*/

/************************ Defines *****************************/
/************************ Enums *******************************/
/************************ Typedefs ****************************/
/************************ Structs *****************************/
/************************ Public Variables ********************/
/************************ Public Functions ********************/

/**
****************************************************************
* Function Name: 
* LLF_GetErrorDescription
*
*  @param error [in] - error code that is used to retrieve error
*                      description.
*
* @returns \b
*  DxUint8_t* - pointer to the specified error description string.
*
* \brief \b 
* Description:
*  This function returns error description using error code.
*
*  \b 
* Algorithm:
*  -# Verify input parameters for validity;
*  -# Call low level function to get error string by error code
*     according input error variable.
***************************************************************/
DxUint8_t* LLF_GetErrorDescription(CE2Error_t error/* in */);

#ifdef __cplusplus
}
#endif

#endif /* LLF_ERROR_H */
